/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.settlement.ItemTracker;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.actions.FurnitureSelectedAction;
import technology.rocketjump.undermount.ui.actions.SetInteractionMode;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.views.FurnitureSelectedCallback;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;
import technology.rocketjump.undermount.ui.widgets.IconButtonFactory;

public class FurnitureSelectionGuiView
implements GuiView,
FurnitureSelectedCallback {
    private final int ITEMS_PER_ROW = 4;
    private final IconButtonFactory iconButtonFactory;
    private final FurnitureTypeDictionary furnitureTypeDictionary;
    private final ItemTracker itemTracker;
    private final I18nTranslator i18nTranslator;
    private final MessageDispatcher messageDispatcher;
    private final Table furnitureTable;
    private final Label headingLabel;
    private final Label typeLabel;
    private final TextButton backButton;
    private final TextButton nextButton;
    private Table viewTable;
    private SelectBox<GameMaterialType> materialTypeSelect;
    private SelectBox materialSelect;
    private GameMaterialType selectedMaterialType = GameMaterialType.WOOD;
    private GameMaterial selectedMaterial;
    private Map<GameMaterialType, ItemType> resourceTypeMap = new TreeMap<GameMaterialType, ItemType>();
    private Map<String, GameMaterial> currentMaterialNamesMap = new HashMap<String, GameMaterial>();
    private RoomType currentRoomType;

    @Inject
    public FurnitureSelectionGuiView(GuiSkinRepository guiSkinRepository, final MessageDispatcher messageDispatcher, IconButtonFactory iconButtonFactory, FurnitureTypeDictionary furnitureTypeDictionary, ItemTypeDictionary itemTypeDictionary, ItemTracker itemTracker, I18nTranslator i18nTranslator) {
        this.messageDispatcher = messageDispatcher;
        this.iconButtonFactory = iconButtonFactory;
        this.furnitureTypeDictionary = furnitureTypeDictionary;
        this.itemTracker = itemTracker;
        this.i18nTranslator = i18nTranslator;
        this.resourceTypeMap.put(GameMaterialType.WOOD, itemTypeDictionary.getByName("Resource-Planks"));
        this.resourceTypeMap.put(GameMaterialType.STONE, itemTypeDictionary.getByName("Resource-Stone-Block"));
        this.resourceTypeMap.put(GameMaterialType.METAL, itemTypeDictionary.getByName("Resource-Metal-Ingot"));
        Skin uiSkin = guiSkinRepository.getDefault();
        this.viewTable = new Table(uiSkin);
        this.viewTable.background("default-rect");
        this.headingLabel = new Label((CharSequence)i18nTranslator.getTranslatedString("GUI.BUILD_FURNITURE"), uiSkin);
        this.viewTable.add(this.headingLabel).center().colspan(2);
        this.viewTable.row();
        this.materialTypeSelect = new SelectBox(uiSkin);
        this.resetMaterialTypeSelect(Arrays.asList(GameMaterialType.WOOD, GameMaterialType.STONE));
        this.materialTypeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FurnitureSelectionGuiView.this.selectedMaterialType = (GameMaterialType)((Object)FurnitureSelectionGuiView.this.materialTypeSelect.getSelected());
                FurnitureSelectionGuiView.this.resetMaterialSelect();
            }
        });
        this.typeLabel = new Label((CharSequence)"Type:", uiSkin);
        this.viewTable.add(this.typeLabel).right();
        this.viewTable.add(this.materialTypeSelect).left();
        this.materialSelect = new SelectBox(uiSkin);
        Array<String> materialNamesArray = new Array<String>();
        materialNamesArray.add("Something");
        this.materialSelect.setItems(materialNamesArray);
        this.materialSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                FurnitureSelectionGuiView.this.onMaterialSelectionChange();
            }
        });
        this.viewTable.row();
        this.furnitureTable = new Table(uiSkin);
        this.furnitureTable.setWidth(400.0f);
        this.furnitureTable.setHeight(300.0f);
        this.resetFurnitureTable();
        ScrollPane scrollPane = new ScrollPane((Actor)this.furnitureTable, uiSkin);
        scrollPane.setScrollingDisabled(true, false);
        scrollPane.setForceScroll(false, true);
        ScrollPane.ScrollPaneStyle scrollPaneStyle = new ScrollPane.ScrollPaneStyle(uiSkin.get(ScrollPane.ScrollPaneStyle.class));
        scrollPaneStyle.background = null;
        scrollPane.setStyle(scrollPaneStyle);
        scrollPane.setFadeScrollBars(false);
        this.viewTable.add(scrollPane).colspan(2);
        this.viewTable.row();
        this.backButton = new TextButton("Back", uiSkin);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                messageDispatcher.dispatchMessage(251, (Object)GuiViewName.ROOM_SIZING);
                messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
            }
        });
        this.viewTable.add(this.backButton).pad(10.0f).left().colspan(1);
        this.nextButton = new TextButton("Done", uiSkin);
        this.nextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                messageDispatcher.dispatchMessage(251, (Object)GuiViewName.DEFAULT_MENU);
            }
        });
        this.viewTable.add(this.nextButton).pad(10.0f).right().colspan(1);
        this.onLanguageUpdated();
    }

    private void onMaterialSelectionChange() {
        this.selectedMaterial = this.currentMaterialNamesMap.get(this.materialSelect.getSelected());
        this.messageDispatcher.dispatchMessage(802, this.selectedMaterial);
    }

    @Override
    public GuiViewName getName() {
        return GuiViewName.ROOM_FURNITURE_SELECTION;
    }

    @Override
    public void populate(Table containerTable) {
        containerTable.clear();
        this.resetMaterialSelect();
        this.resetFurnitureTable();
        containerTable.add(this.viewTable);
    }

    @Override
    public void furnitureTypeSelected(FurnitureType furnitureType) {
        if (furnitureType.getName().equals("BASIC_LANTERN")) {
            this.resetMaterialTypeSelect(Arrays.asList(GameMaterialType.METAL));
        } else if (this.materialTypeSelect.getSelected().equals((Object)GameMaterialType.METAL)) {
            this.resetMaterialTypeSelect(Arrays.asList(GameMaterialType.WOOD, GameMaterialType.STONE));
        }
    }

    @Override
    public void update() {
    }

    private void resetFurnitureTable() {
        if (this.currentRoomType == null) {
            return;
        }
        this.furnitureTable.clearChildren();
        int numRoomsAdded = 0;
        LinkedList<FurnitureType> furnitureTypesForRoom = new LinkedList<FurnitureType>();
        for (String furnitureName : this.currentRoomType.getFurnitureNames()) {
            FurnitureType furnitureType = this.furnitureTypeDictionary.getByName(furnitureName);
            if (furnitureType == null) {
                System.err.println("Could not find furniture type by name " + furnitureName + " for room " + this.currentRoomType);
                continue;
            }
            furnitureTypesForRoom.add(furnitureType);
        }
        furnitureTypesForRoom.addAll(this.furnitureTypeDictionary.getPlaceAnywhereFurniture());
        for (FurnitureType furnitureType : furnitureTypesForRoom) {
            if (furnitureType.getFurnitureCategory() == null) continue;
            IconButton iconButton = this.iconButtonFactory.create(furnitureType.getI18nKey(), furnitureType.getIconName(), furnitureType.getColor(), ButtonStyle.LARGE);
            iconButton.setAction(new FurnitureSelectedAction(furnitureType, this.messageDispatcher, this));
            this.furnitureTable.add(iconButton).pad(10.0f);
            if (++numRoomsAdded % 4 != 0) continue;
            this.furnitureTable.row();
        }
        FurnitureType doorFurnitureType = this.furnitureTypeDictionary.getByName("SINGLE_DOOR");
        IconButton iconButton = this.iconButtonFactory.create(doorFurnitureType.getI18nKey(), doorFurnitureType.getIconName(), doorFurnitureType.getColor(), ButtonStyle.LARGE);
        iconButton.setAction(new SetInteractionMode(GameInteractionMode.PLACE_DOOR, this.messageDispatcher));
        this.furnitureTable.add(iconButton).pad(10.0f);
        if (++numRoomsAdded % 4 == 0) {
            this.furnitureTable.row();
        }
    }

    private void resetMaterialTypeSelect(Iterable<GameMaterialType> validTypes) {
        Array<GameMaterialType> itemsArray = new Array<GameMaterialType>();
        for (GameMaterialType gameMaterialType : validTypes) {
            itemsArray.add(gameMaterialType);
        }
        this.materialTypeSelect.setItems(itemsArray);
        this.materialTypeSelect.setSelected((GameMaterialType)((Object)itemsArray.get(0)));
        this.resetMaterialSelect();
    }

    private void resetMaterialSelect() {
        Array<String> materialTypes = new Array<String>();
        ItemType itemTypeForMaterialType = this.resourceTypeMap.get((Object)this.selectedMaterialType);
        Set<GameMaterial> materialsByItemType = this.itemTracker.getMaterialsByItemType(itemTypeForMaterialType);
        if (materialsByItemType != null) {
            this.currentMaterialNamesMap.clear();
            for (GameMaterial gameMaterial : materialsByItemType) {
                materialTypes.add(gameMaterial.getMaterialName());
                this.currentMaterialNamesMap.put(gameMaterial.getMaterialName(), gameMaterial);
            }
            this.materialSelect.setItems(materialTypes);
            if (materialTypes.size > 0) {
                this.materialSelect.setSelected(materialTypes.get(0));
                this.selectedMaterial = this.currentMaterialNamesMap.get(materialTypes.get(0));
            }
            this.onMaterialSelectionChange();
        }
    }

    public void setCurrentRoomType(RoomType currentRoomType) {
        this.currentRoomType = currentRoomType;
    }

    public RoomType getCurrentRoomType() {
        return this.currentRoomType;
    }

    @Override
    public void onLanguageUpdated() {
        this.headingLabel.setText(this.i18nTranslator.getTranslatedString("GUI.BUILD_FURNITURE"));
        this.typeLabel.setText(this.i18nTranslator.getTranslatedString("MATERIAL_TYPE"));
        this.backButton.setText(this.i18nTranslator.getTranslatedString("GUI.BACK_LABEL"));
        this.nextButton.setText(this.i18nTranslator.getTranslatedString("GUI.NEXT_LABEL"));
        this.resetFurnitureTable();
        this.resetMaterialTypeSelect(this.materialTypeSelect.getItems());
    }
}

